const fs = require('fs');
const path = require('path');

/**
 * Creates default asset files if they don't exist
 */
function createDefaultAssets() {
  const assetsDir = path.join(__dirname, '..', 'assets');
  
  // Create assets directory if it doesn't exist
  if (!fs.existsSync(assetsDir)) {
    console.log('Creating assets directory...');
    fs.mkdirSync(assetsDir, { recursive: true });
  }
  
  // Check for security status images
  const securityImages = [
    'img-safe.png',
    'img-likely-safe.png',
    'img-caution.png',
    'img-high-risk.png',
    'img-unknown.png'
  ];
  
  // Skip image creation if canvas is not available
  // Just log a warning and continue
  for (const imgName of securityImages) {
    const imgPath = path.join(assetsDir, imgName);
    if (!fs.existsSync(imgPath)) {
      console.warn(`Skipping creation of ${imgName} (canvas module not available)`);
    }
  }
  
  console.log('Default assets check completed');
}

/**
 * Creates a security status image
 */


module.exports = {
  createDefaultAssets
};
